/*
 * Decompiled with CFR 0.152.
 */
package com.pikachu.mod.illager_more.client.renderers.entity;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexMultiConsumer;
import com.mojang.math.Vector3f;
import com.pikachu.mod.illager_more.client.models.DefaultGeoModel;
import com.pikachu.mod.illager_more.client.models.illager.VanillaIllagerModel;
import com.pikachu.mod.illager_more.entities.ShogunEntity;
import java.util.Collections;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.event.RenderNameTagEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.ModList;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.compat.PatchouliCompat;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.processor.IBone;
import software.bernie.geckolib3.core.util.Color;
import software.bernie.geckolib3.geo.render.built.GeoBone;
import software.bernie.geckolib3.geo.render.built.GeoModel;
import software.bernie.geckolib3.item.GeoArmorItem;
import software.bernie.geckolib3.model.provider.data.EntityModelData;
import software.bernie.geckolib3.renderers.geo.ExtendedGeoEntityRenderer;
import software.bernie.geckolib3.renderers.geo.GeoArmorRenderer;
import software.bernie.geckolib3.renderers.geo.GeoLayerRenderer;
import software.bernie.geckolib3.util.EModelRenderCycle;
import software.bernie.geckolib3.util.IRenderCycle;

public class DefaultExtendedGeoEntityRenderer<T extends AbstractIllager>
extends ExtendedGeoEntityRenderer<T> {
    protected ItemStack mainHandItem;
    protected ItemStack offHandItem;
    protected ItemStack helmetItem;
    protected ItemStack chestplateItem;
    protected ItemStack leggingsItem;
    protected ItemStack bootsItem;

    public DefaultExtendedGeoEntityRenderer(EntityRendererProvider.Context renderManager, String geoNames, String animationNames, String texturesNames, VanillaIllagerModel<T> model) {
        super(renderManager, new DefaultGeoModel(geoNames, animationNames, texturesNames));
    }

    public DefaultExtendedGeoEntityRenderer(EntityRendererProvider.Context renderManager, String geoNames, String animationNames, String texturesNames) {
        super(renderManager, new DefaultGeoModel(geoNames, animationNames, texturesNames));
    }

    public void render(T animatable, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        Direction bedDirection;
        Entity entity;
        Entity leashHolder;
        this.setCurrentModelRenderCycle((IRenderCycle)EModelRenderCycle.INITIAL);
        poseStack.m_85836_();
        if (animatable instanceof AbstractIllager && (leashHolder = animatable.m_21524_()) != null) {
            this.renderLeash((LivingEntity)animatable, partialTick, poseStack, bufferSource, leashHolder);
        }
        this.dispatchedMat = poseStack.m_85850_().m_85861_().m_27658_();
        boolean geoShouldSit = animatable.m_20159_() && animatable.m_20202_() != null && animatable.m_20202_().shouldRiderSit();
        EntityModelData entityModelData = new EntityModelData();
        entityModelData.isSitting = geoShouldSit;
        entityModelData.isChild = animatable.m_6162_();
        float lerpBodyRot = Mth.m_14189_((float)partialTick, (float)((AbstractIllager)animatable).f_20884_, (float)((AbstractIllager)animatable).f_20883_);
        float lerpHeadRot = Mth.m_14189_((float)partialTick, (float)((AbstractIllager)animatable).f_20886_, (float)((AbstractIllager)animatable).f_20885_);
        float netHeadYaw = lerpHeadRot - lerpBodyRot;
        if (geoShouldSit && (entity = animatable.m_20202_()) instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity;
            lerpBodyRot = Mth.m_14189_((float)partialTick, (float)livingentity.f_20884_, (float)livingentity.f_20883_);
            netHeadYaw = lerpHeadRot - lerpBodyRot;
            float clampedHeadYaw = Mth.m_14036_((float)Mth.m_14177_((float)netHeadYaw), (float)-85.0f, (float)85.0f);
            lerpBodyRot = lerpHeadRot - clampedHeadYaw;
            if (clampedHeadYaw * clampedHeadYaw > 2500.0f) {
                lerpBodyRot += clampedHeadYaw * 0.2f;
            }
            netHeadYaw = lerpHeadRot - lerpBodyRot;
        }
        if (animatable.m_20089_() == Pose.SLEEPING && (bedDirection = animatable.m_21259_()) != null) {
            float eyePosOffset = animatable.m_20236_(Pose.STANDING) - 0.1f;
            poseStack.m_85837_((double)((float)(-bedDirection.m_122429_()) * eyePosOffset), 0.0, (double)((float)(-bedDirection.m_122431_()) * eyePosOffset));
        }
        float ageInTicks = (float)((AbstractIllager)animatable).f_19797_ + partialTick;
        float limbSwingAmount = 0.0f;
        float limbSwing = 0.0f;
        this.applyRotations((LivingEntity)animatable, poseStack, ageInTicks, lerpBodyRot, partialTick);
        if (!geoShouldSit && animatable.m_6084_()) {
            limbSwingAmount = Mth.m_14179_((float)partialTick, (float)((AbstractIllager)animatable).f_20923_, (float)((AbstractIllager)animatable).f_20924_);
            limbSwing = ((AbstractIllager)animatable).f_20925_ - ((AbstractIllager)animatable).f_20924_ * (1.0f - partialTick);
            if (animatable.m_6162_()) {
                limbSwing *= 3.0f;
            }
            if (limbSwingAmount > 1.0f) {
                limbSwingAmount = 1.0f;
            }
        }
        float headPitch = Mth.m_14179_((float)partialTick, (float)((AbstractIllager)animatable).f_19860_, (float)animatable.m_146909_());
        entityModelData.headPitch = -headPitch;
        entityModelData.netHeadYaw = -netHeadYaw;
        AnimationEvent predicate = new AnimationEvent(animatable, limbSwing, limbSwingAmount, partialTick, limbSwingAmount <= -this.getSwingMotionAnimThreshold() || limbSwingAmount > this.getSwingMotionAnimThreshold(), Collections.singletonList(entityModelData));
        GeoModel geoModel = this.modelProvider.getModel(this.modelProvider.getModelResource(animatable));
        this.modelProvider.setCustomAnimations(animatable, this.getInstanceId((LivingEntity)animatable), predicate);
        poseStack.m_85837_(0.0, (double)0.01f, 0.0);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.getTextureLocation((LivingEntity)animatable));
        Color renderColor = this.getRenderColor(animatable, partialTick, poseStack, bufferSource, null, packedLight);
        RenderType renderType = this.getRenderType(animatable, partialTick, poseStack, bufferSource, null, packedLight, this.getTextureLocation((LivingEntity)animatable));
        if (Minecraft.m_91087_().f_91074_ != null && !animatable.m_20177_((Player)Minecraft.m_91087_().f_91074_)) {
            VertexConsumer translucentBuffer;
            VertexConsumer glintBuffer = bufferSource.m_6299_(RenderType.m_110499_());
            this.render(geoModel, (LivingEntity)animatable, partialTick, renderType, poseStack, bufferSource, glintBuffer != (translucentBuffer = bufferSource.m_6299_(RenderType.m_110470_((ResourceLocation)this.getTextureLocation((LivingEntity)animatable)))) ? VertexMultiConsumer.m_86168_((VertexConsumer)glintBuffer, (VertexConsumer)translucentBuffer) : null, packedLight, this.getOverlay((LivingEntity)animatable, 0.0f), (float)renderColor.getRed() / 255.0f, (float)renderColor.getGreen() / 255.0f, (float)renderColor.getBlue() / 255.0f, (float)renderColor.getAlpha() / 255.0f);
        }
        if (!animatable.m_5833_()) {
            for (GeoLayerRenderer layerRenderer : this.layerRenderers) {
                this.renderLayer(poseStack, bufferSource, packedLight, (LivingEntity)animatable, limbSwing, limbSwingAmount, partialTick, ageInTicks, netHeadYaw, headPitch, bufferSource, layerRenderer);
            }
        }
        if (ModList.get().isLoaded("patchouli")) {
            PatchouliCompat.patchouliLoaded((PoseStack)poseStack);
        }
        poseStack.m_85849_();
        RenderNameTagEvent renderNameTagEvent = new RenderNameTagEvent(animatable, animatable.m_5446_(), (EntityRenderer)this, poseStack, bufferSource, packedLight, partialTick);
        MinecraftForge.EVENT_BUS.post((Event)renderNameTagEvent);
        if (renderNameTagEvent.getResult() != Event.Result.DENY && (renderNameTagEvent.getResult() == Event.Result.ALLOW || this.shouldShowName((LivingEntity)animatable))) {
            this.m_7649_((Entity)animatable, renderNameTagEvent.getContent(), poseStack, bufferSource, packedLight);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void renderRecursively(GeoBone bone, PoseStack stack, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        block3: {
            if (this.isArmorBone(bone)) {
                bone.setHidden(true);
            }
            if (!bone.getName().equals("headWear") || this.helmetItem.m_41720_() instanceof ArmorItem) break block3;
            stack.m_85836_();
            stack.m_85845_(Vector3f.f_122223_.m_122240_(0.0f));
            stack.m_85845_(Vector3f.f_122225_.m_122240_(0.0f));
            stack.m_85845_(Vector3f.f_122227_.m_122240_(0.0f));
            stack.m_85837_(0.0, 1.75, 0.0);
            stack.m_85841_(0.6f, 0.6f, 0.6f);
            v0 = Minecraft.m_91087_().m_91291_();
            var11_10 = this.currentEntityBeingRendered;
            if (!(var11_10 instanceof ShogunEntity)) ** GOTO lbl-1000
            shogun = (ShogunEntity)var11_10;
            if (shogun.isLeader) {
                v1 = Raid.m_37779_();
            } else lbl-1000:
            // 2 sources

            {
                v1 = this.helmetItem;
            }
            v0.m_174269_(v1, ItemTransforms.TransformType.HEAD, packedLightIn, packedOverlayIn, stack, this.rtb, 0);
            stack.m_85849_();
            bufferIn = this.rtb.m_6299_(RenderType.m_110473_((ResourceLocation)this.whTexture));
        }
        super.renderRecursively(bone, stack, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
    }

    @Nullable
    protected ResourceLocation getTextureForBone(String boneName, T animatable) {
        return null;
    }

    protected boolean isArmorBone(GeoBone bone) {
        return bone.getName().startsWith("armor");
    }

    public void renderEarly(T animatable, PoseStack poseStack, float partialTick, MultiBufferSource bufferSource, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float partialTicks) {
        super.renderEarly(animatable, poseStack, partialTick, bufferSource, buffer, packedLight, packedOverlay, red, green, blue, partialTicks);
        this.mainHandItem = animatable.m_6844_(EquipmentSlot.MAINHAND);
        this.offHandItem = animatable.m_6844_(EquipmentSlot.OFFHAND);
        this.helmetItem = animatable.m_6844_(EquipmentSlot.HEAD);
        this.chestplateItem = animatable.m_6844_(EquipmentSlot.CHEST);
        this.leggingsItem = animatable.m_6844_(EquipmentSlot.LEGS);
        this.bootsItem = animatable.m_6844_(EquipmentSlot.FEET);
    }

    protected ItemStack getHeldItemForBone(String boneName, T currentEntity) {
        return switch (boneName) {
            case "bipedHandLeft" -> this.offHandItem;
            case "bipedHandRight", "bipedHandRight2" -> this.mainHandItem;
            default -> null;
        };
    }

    protected ItemTransforms.TransformType getCameraTransformForItemAtBone(ItemStack boneItem, String boneName) {
        return switch (boneName) {
            case "bipedHandLeft", "bipedHandRight", "bipedHandRight2" -> ItemTransforms.TransformType.THIRD_PERSON_RIGHT_HAND;
            default -> ItemTransforms.TransformType.NONE;
        };
    }

    protected void preRenderItem(PoseStack stack, ItemStack item, String boneName, T currentEntity, IBone bone) {
        if (item == this.mainHandItem || item == this.offHandItem) {
            stack.m_85841_(1.1f, 1.1f, 1.1f);
            stack.m_85845_(Vector3f.f_122223_.m_122240_(-90.0f));
            boolean shieldFlag = item.m_41720_() instanceof ShieldItem;
            if (item == this.mainHandItem) {
                if (shieldFlag) {
                    stack.m_85837_(0.0, 0.125, -0.25);
                }
            } else if (shieldFlag) {
                stack.m_85837_(-0.15, 0.125, 0.05);
                stack.m_85845_(Vector3f.f_122225_.m_122240_(90.0f));
            }
        }
    }

    protected void postRenderItem(PoseStack matrixStack, ItemStack item, String boneName, T currentEntity, IBone bone) {
    }

    @Nullable
    protected ItemStack getArmorForBone(String boneName, T currentEntity) {
        switch (boneName) {
            case "armorBipedLeftFoot": 
            case "armorBipedRightFoot": {
                return this.bootsItem;
            }
            case "armorBipedLeftLeg": 
            case "armorBipedRightLeg": {
                return this.leggingsItem;
            }
            case "armorBipedBody": 
            case "armorBipedRightArm": 
            case "armorBipedLeftArm": 
            case "armorIllagerRightArm": 
            case "armorIllagerLeftArm": {
                return this.chestplateItem;
            }
            case "armorBipedHead": {
                return this.helmetItem;
            }
        }
        return null;
    }

    protected EquipmentSlot getEquipmentSlotForArmorBone(String boneName, T currentEntity) {
        switch (boneName) {
            case "armorBipedLeftFoot": 
            case "armorBipedRightFoot": {
                return EquipmentSlot.FEET;
            }
            case "armorBipedLeftLeg": 
            case "armorBipedRightLeg": {
                return EquipmentSlot.LEGS;
            }
            case "armorBipedLeftArm": 
            case "armorIllagerLeftArm": {
                return EquipmentSlot.MAINHAND;
            }
            case "armorBipedRightArm": 
            case "armorIllagerRightArm": {
                return EquipmentSlot.OFFHAND;
            }
            case "armorBipedBody": {
                return EquipmentSlot.CHEST;
            }
            case "armorBipedHead": {
                return EquipmentSlot.HEAD;
            }
        }
        return null;
    }

    protected ModelPart getArmorPartForBone(String name, HumanoidModel<?> armorBipedModel) {
        switch (name) {
            case "armorBipedLeftFoot": 
            case "armorBipedLeftLeg": {
                return armorBipedModel.f_102814_;
            }
            case "armorBipedRightFoot": 
            case "armorBipedRightLeg": {
                return armorBipedModel.f_102813_;
            }
            case "armorBipedRightArm": 
            case "armorIllagerRightArm": {
                return armorBipedModel.f_102811_;
            }
            case "armorBipedLeftArm": 
            case "armorIllagerLeftArm": {
                return armorBipedModel.f_102812_;
            }
            case "armorBipedBody": {
                return armorBipedModel.f_102810_;
            }
            case "armorBipedHead": {
                return armorBipedModel.f_102808_;
            }
        }
        return null;
    }

    protected BlockState getHeldBlockForBone(String boneName, T currentEntity) {
        return null;
    }

    protected void preRenderBlock(PoseStack stack, BlockState block, String boneName, T currentEntity) {
    }

    protected void postRenderBlock(PoseStack stack, BlockState block, String boneName, T currentEntity) {
    }

    protected void setLimbBoneVisible(GeoArmorRenderer<? extends GeoArmorItem> armorRenderer, ModelPart limb, HumanoidModel<?> armorModel, EquipmentSlot slot) {
        if (limb == armorModel.f_102808_ || limb == armorModel.f_102809_) {
            armorRenderer.getGeoModelProvider().getBone(armorRenderer.headBone).setHidden(false);
        } else if (limb == armorModel.f_102810_) {
            armorRenderer.getGeoModelProvider().getBone(armorRenderer.bodyBone).setHidden(false);
            armorRenderer.getGeoModelProvider().getBone(armorRenderer.leftArmBone).setHidden(true);
            armorRenderer.getGeoModelProvider().getBone(armorRenderer.rightArmBone).setHidden(true);
        } else if (limb == armorModel.f_102812_) {
            armorRenderer.getGeoModelProvider().getBone(armorRenderer.bodyBone).setHidden(true);
            armorRenderer.getGeoModelProvider().getBone(armorRenderer.leftArmBone).setHidden(false);
            armorRenderer.getGeoModelProvider().getBone(armorRenderer.rightArmBone).setHidden(true);
        } else if (limb == armorModel.f_102814_) {
            armorRenderer.getGeoModelProvider().getBone(slot == EquipmentSlot.FEET ? armorRenderer.leftBootBone : armorRenderer.leftLegBone).setHidden(false);
            armorRenderer.getGeoModelProvider().getBone(slot == EquipmentSlot.FEET ? armorRenderer.rightBootBone : armorRenderer.rightLegBone).setHidden(true);
        } else if (limb == armorModel.f_102811_) {
            armorRenderer.getGeoModelProvider().getBone(armorRenderer.bodyBone).setHidden(true);
            armorRenderer.getGeoModelProvider().getBone(armorRenderer.leftArmBone).setHidden(true);
            armorRenderer.getGeoModelProvider().getBone(armorRenderer.rightArmBone).setHidden(false);
        } else if (limb == armorModel.f_102813_) {
            armorRenderer.getGeoModelProvider().getBone(slot == EquipmentSlot.FEET ? armorRenderer.rightBootBone : armorRenderer.rightLegBone).setHidden(false);
            armorRenderer.getGeoModelProvider().getBone(slot == EquipmentSlot.FEET ? armorRenderer.leftBootBone : armorRenderer.leftLegBone).setHidden(true);
        }
    }
}

